	org 65169


;===============================================================================	
	; USR 65169 - Variable mc - Routine to get the required values from
	; array A$(1 TO 4), poke them into the right places, launch the main
	; Illuminati routine, and dump the result back into A$(5 TO 6).
vars:	equ 23627
	; for an array DIM A$(6) at the beginning of the BASIC program:
	; the elements of the array are stored at (VARS)+6 to (VARS)+11
	ld hl,(vars)
	ld de,6		; first element is 6 bytes beyond (VARS)
	add hl,de	; HL points at the first element in A$
	ld de,65520	; can reassign DE to where it needs to be
	; POKE va,CODE a$(1)
	; POKE va+1,CODE a$(2)
	; POKE va+2,CODE a$(3)
	; POKE va+3,CODE a$(4)
	ld b,4	; four times, transfer (HL) to (DE) via A
loop1a:	ld a,(hl)
	ld (de),a
	inc hl
	inc de
	djnz loop1a
	; LET u=USR 65000
	push hl
	push de		
	call 65000
	pop de		; only four bytes to get the HL/DE values 
	pop hl		; back via the stack
	; LET a$(5)=CHR$ (PEEK (va+4))
	; LET a$(6)=CHR$ (PEEK (va+5))
	; HL is pointing at A$(5), DE at va+4
	ld b,2	; twice, transfer (DE) to (HL) via A
loop1b:	ld a,(de)
	ld (hl),a
	inc hl
	inc de
	djnz loop1b
	ret



;===============================================================================
	; USR 65203 - Variable xp - K.J. Bezant's explosion (from Nifty Lifty,
	; Killer Tomatoes, 1994, Sheer Panic and anything else he wrote)
	; With a bit of help from Dave Hughes, originally...
	; Border always turns black, which is not a problem here.
	ld bc,4000
	ld hl,0
loop2a:	push bc
	ld a,248
	bit 0,(hl)
	jr z,loop2b
	ld a,232
loop2b:	out (254),a
	ld a,h
	add a,0
	add a,a
	add a,a
	ld b,a
loop2c:	djnz loop2c
	pop bc
	inc hl
	dec bc
	ld a,b
	or c
	jr nz,loop2a
	ret


;===============================================================================	
	; USR 65236 - Variable ft - Falling "zap" tone from M.J. Levers' Defender
	ld hl,15	
loop3:	ld de,20
	push hl
	call 949
	pop hl
	ld de,10
	and a
	adc hl,de
	ld a,l
	cp 255
	jr nz,loop3
	ret				; no check if L has reached 255 irrespective of H


;===============================================================================
	; USR 65259 - Variable rt - Rising "ZOOM" effect similar to SAM Coupe
	ld hl,255	; original 255
loop4:	ld de,6		; original 6, maybe need 20?
	push hl
	call 949
	pop hl
	ld de,3		; original 3, maybe need 1?
	and a
	sbc hl,de
	jr nz,loop4
	ret				; no check if L has reached 255 irrespective of H
	

;===============================================================================
	; USR 65279 - Variable cr - "Crash" sound effect from Starfire
	 ld b,1	; 65071 = 4
loop5a:	push bc
	ld bc,1380	; two bytes, 65074 = 100, 65075 = 5
	ld de,1	; 65077 = 1, 65078 = 0
loop5b:	push bc
	pop hl
	ld l,(hl)
	ld h,0
	push de
	push bc
	call 949	; beeper
	ld bc,10	; 65090 = 10 (high byte 65091 = 0)
loop5c:	dec bc
	ld a,b
	or c
	jr nz,loop5c
	pop bc
	pop de
	dec bc
	ld a,b
	cp 3
	jr nz,loop5b
	pop bc
	djnz loop5a
	ret

;===============================================================================
	; 65318 - Variable hx - Data for hex code positions in the pyramid
	defb 1,2,6,17,9
	defb 2,3,7,17,13
	defb 3,4,8,17,17
	defb 4,5,9,17,21
	defb 6,7,10,15,11
	defb 7,8,11,15,15
	defb 8,9,12,15,19
	defb 10,11,13,13,13
	defb 11,12,14,13,17
	defb 13,14,15,11,15


;===============================================================================
	; 65368 - UDG data
	; test that it's all in place properly by looking at the UDGs
	; A = dithere square (ZX81 graphic H)
	defb 85,170,85,170,85,170,85,170
	; BC = key at top of pyramid
	defb 0,56,68,71,68,56,0,0
	defb 0,0,0,254,42,34,0,0
	; DE = milk bottle
	defb 60,66,36,36,36,122,126,253
	defb 253,253,253,253,253,253,253,255
	; F,G = standard ZX81 inverse dithered half squares
	defb 85,170,85,170,255,255,255,255
	defb 255,255,255,255,85,170,85,170
	; HI/JK = slice of toast
	defb 63,64,191,187,150,107,86,91
	defb 252,2,253,109,217,118,218,106
	defb 86,91,86,91,86,95,64,63
	defb 218,106,218,106,218,250,2,252
	; LM/NO = NPC face
	defb 7,31,63,63,127,127,127,126
	defb 192,240,248,252,252,254,254,82
	defb 126,63,55,23,23,27,29,30
	defb 82,238,238,246,6,252,4,248
	; PR/RS = Pepe face
	defb 0,15,16,63,120,183,164,184
	defb 0,120,140,118,3,189,165,2
	defb 247,252,255,240,207,240,127,63
	defb 124,226,254,2,254,4,248,224
	; T = reserved for use with the Illuminati routine
	; all should be set to 0
	defb 0,0,0,0,0,0,0,0
	; U = "anything else"
	; first byte sets the Spice Level and it 1 by default
	defb 1
	; next five bytes are unused
	defb 0,0,0,0,0
	; 65534 holds the value to POKE 23607 with for the custom character set -
	; POKE 65534,60 will disable the character set until the value is re-poked
	; or the code is reloaded, making editing on the +3 easier
	defb 178
	; final byte (65535) is set to 255 when all the code is loaded
	defb 255



